###############################################################################################
###                           Script for QTLs detection with Rqtl                           ###
###############################################################################################

library(qtl)

#load data; genotypes file= linkage_map_genotypes.csv phenotypes file= phenotypes.csv
gesneria<-read.cross("csvs", genfile="linkage_map_genotypes.csv", phefile="phenotypes.csv",sep=",", dec=".")
gesneria<-jittermap(gesneria)

# calculate genotypes probabilities for markers and pseudo-markers
gesneria.prob<-calc.genoprob(gesneria,step=1)

# calculate null-distribtuion of LOD-scores for one phenotype and get the thresold value for alpha=5%. One must change pheno.col number to change the phenotype

## for quantitative phenotypes
gesneria.scan1.perm<-scanone(gesneria.prob,pheno.col=3,model=("normal"),method="hk",n.perm=10000)
summary(gesneria.scan1.perm,0.05)

## for binary phenotypes
gesneria.scan1.perm<-scanone(gesneria.prob,pheno.col=2,model=("binary"),method="em",n.perm=10000)
summary(gesneria.scan1.perm,0.05)

# Estimate LOD-scores for the observed data
## for quantitative phenotypes
gesneria.scan1<-scanone(gesneria.prob,pheno.col=3,model=("normal"),method="hk")
summary(gesneria.scan1)

## for binary phenotypes
gesneria.scan1<-scanone(gesneria.prob,pheno.col=2,model=("binary"),method="em")
summary(gesneria.scan1)

# If some QTLs are detected, one want to detect minor QTLs, integrating primary QTLs as 
# covariate in the model

## define the covariate. One must change chr and marker name parameters
qtl_c1<-as.data.frame(pull.geno(gesneria,chr="lg1"))
qtl<-qtl_c1$stacks_18077

## detect QTLs with covariates, here for quantiative phenotypes
gesneria.scan1.perm<-scanone(gesneria.prob,pheno.col=3,model=("normal"),addcovar=qtl,method="hk",n.perm=10000)

summary(gesneria.scan1.perm,0.05)
gesneria.scan1<-scanone(gesneria.prob,pheno.col=3,model=("normal"),method="hk",addcovar=qtl)
summary(gesneria.scan1)

# Find QTLs confidence region with a 2-LOD support. One must change chr and qtl.index parameters 
lodint(gesneria.scan1,chr="lg1",qtl.index=15.3,drop=2)

# Estimate purcentage of variance explained by each QTLs and additive effects
# Include every QTLs found in the model
qtl.final<-makeqtl(gesneria.prob,chr=c("lg1","lg16"),pos=c(15.3,85),what="prob")
gesneria.model<-fitqtl(gesneria.prob,pheno.col=123,qtl=qtl.final,formula=y~Q1+Q2,method="hk",model="normal",get.ests=T)
summary(gesneria.model)
