# Genotype.R

#open the file genotypes.tsv
data <- read.delim("batch_1.genotypes_20.tsv",header=TRUE,stringsAsFactors=F)
data[data == '--'] <- '-'

#open the table of genotypes
geno_table <- read.csv2('geno_table.csv',header=FALSE,comment.char="#",
                        strip.white=TRUE,blank.lines.skip = TRUE,sep=";")
write.table(geno_table[,-1],file="temp.txt",sep=";",
            quote=F,row.names=F,col.names=F)
F2_geno_table <- scan('temp.txt',what=character(),comment.char="#",quote="",
                      strip.white=TRUE,blank.lines.skip = TRUE,sep=";")

#convert into 3D array
progeny_types<-c('aa','ab','ac','ad','bb','bc','bd','cc','cd','dd','-')
cross_types<-c('aa/bb','ab/aa','aa/ab','ab/ac','ab/cc','cc/ab',
               'ab/cd','ab/--','--/ab','ab/ab')
dim(F2_geno_table)<-c(11,11,10)
dimnames(F2_geno_table)<-list(progeny_types,progeny_types,cross_types)
# now,F2 are in row, F1 in column and cross-type in the third dimension

#recode the genotypes
output<-as.data.frame(data[,-c(1,3:4)])
for (i in 1:nrow(output)){
  type<-as.character(data[i,2])
  f1<-tolower(as.character(data[i,5]))
  output[i,3:ncol(output)]<-
    sapply(output[i,3:ncol(output)],function(x,c1,c2) 
      return(F2_geno_table[tolower(as.character(x)),c1,c2]),c1=f1,c2=type)
}

write.table(cbind(data[,1],output),file="data_ABH.txt",sep="\t",col.names=T,row.names=T)



